import dbus

# Connect to the session bus
bus = dbus.SessionBus()

# Get a proxy object, and select the interface we want to use.
dbus_obj = bus.get_object('org.freedesktop.Notifications',
                          '/org/freedesktop/Notifications')
dbus_iface = dbus.Interface(dbus_obj,
                            dbus_interface='org.freedesktop.Notifications')

# Call the 'Notify' method on the interface, and wait for a reply
nid = dbus_iface.Notify('dbus test',  # app_name       (spec names)
                        0,            # replaces_id (0 = new notification)
                        '',           # app_icon
                        'Hello, world',  # summary
                        'Sample DBus notification',  # body
                        [],           # actions
                        {},           # hints
                        -1,           # expire_timeout (-1 = default)
                       )

print('Assigned notification ID:', nid)
