from binascii import hexlify
import os
import select
import socket
import struct
import subprocess
import sys

s = socket.socket(socket.AF_UNIX)
#s.connect(b'\0/tmp/dbus-Z5aGAiSmkS')
s.connect(b'/run/user/1000/bus')

hex_uid = hexlify(str(os.getuid()).encode('ascii'))
s.send(b'\0AUTH EXTERNAL %b\r\n' % hex_uid)
r = s.recv(100)
assert r.startswith(b'OK '), r
assert r.endswith(b'\r\n'), r
s.send(b'BEGIN\r\n')

header = [b'l',    # Little endian
          b'\x01', # Method call
          b'\0',   # Flags
          b'\x01',  # Protocol version
          struct.pack('<II', 0, 1),  # Body size and serial number
         ]

# Each field has a field code, signature (length, type spec), padding, contents.
# String like types have a 4-byte length, then the data
header_fields = [
    b'\x01\x01o\0' + struct.pack('<I', 21) + b'/org/freedesktop/DBus\0',  # Path
    b'\x02\x01s\0' + struct.pack('<I', 20) + b'org.freedesktop.DBus\0',  # Interface
    b'\x06\x01s\0' + struct.pack('<I', 20) + b'org.freedesktop.DBus\0',  # Destination
    b'\x03\x01s\0' + struct.pack('<I', 5) + b'Hello\0',  # Interface
]

def padding_length(l):
    return (8 - (l % 8)) % 8   # Is there a better way to do this?

def padded_length(l):
    return l + padding_length(l)

combined_header_fields = b''
for field in header_fields:
    combined_header_fields += bytes(padding_length(len(combined_header_fields)))
    combined_header_fields += field

#print(combined_header_fields)

hello_msg = b''.join(header) \
            + struct.pack('<I', len(combined_header_fields)) \
            + combined_header_fields + b'\0\0'
print(hello_msg)
s.send(hello_msg)
print('Saying hello')
print('Server responds...')
resp = s.recv(512)

resp_head = struct.unpack('<cBBBIII', resp[:16])
assert resp_head[0] == b'l'  # Little endian
assert resp_head[1] == 2     # Method return
assert resp_head[3] == 1     # Protocol version
body_length = resp_head[4]
header_fields_length = resp_head[6]

padded_header_length = 16 + padded_length(header_fields_length)
body = resp[padded_header_length:padded_header_length+body_length]

# 4 bytes length, 1 byte trailing null
print('My ID is:', body[4:-1].decode('ascii'))
