import os
import select
import socket
import subprocess
import sys

FAKE_DBUS_SOCKET = b'tk-dbus-debug'

to_server = socket.socket(socket.AF_UNIX)
#to_server.connect(b'\0/tmp/dbus-Z5aGAiSmkS')
to_server.connect(b'/run/user/1000/bus')
to_client = socket.socket(socket.AF_UNIX)
to_client.bind(b'/tmp/tk-dbus-debug') #b'\0'+FAKE_DBUS_SOCKET)

to_client.listen()
env = os.environ.copy()
env['DBUS_SESSION_BUS_ADDRESS'] = b'unix:abstract=' + FAKE_DBUS_SOCKET
subprocess.Popen(sys.argv[1:], env=env)

client_conn, addr = to_client.accept()

while True:
    ready, _, _ = select.select([client_conn, to_server], [], [])
    if client_conn in ready:
        data = client_conn.recv(128)
        if not data:
            break
        print('Client:', data)
        to_server.send(data)
    elif to_server in ready:
        data = to_server.recv(128)
        if not data:
            break
        print('Server:', data)
        client_conn.send(data)

client_conn.close()
to_client.close()
to_server.close()
