import struct

def parse_fields(msg):
    header_len, = struct.unpack('<I', msg[12:16])
    print(header_len)
    fields_section = msg[16:16+header_len]
    fields = {}
    pos = 0
    while pos < len(fields_section):
        while pos % 8:
            pos += 1
        fieldno, _, datatype = struct.unpack('<BBc', fields_section[pos:pos+3])
        pos += 4
        if datatype in b'so':
            l, = struct.unpack('<I', fields_section[pos:pos+4])
            pos += 4
            fields[fieldno] = fields_section[pos:pos+l]
            pos += l+1 # +1 for null byte
        elif datatype == b'g':
            l, = struct.unpack('<B', fields_section[pos:pos+1])
            pos += 1
            fields[fieldno] = fields_section[pos:pos+l]
            pos += l+1 # +1 for null byte
        elif datatype == b'u':
            v = struct.unpack('<I', fields_section[pos:pos+4])
            fields[fieldno] = v
    return fields
